package tests;

import static org.junit.jupiter.api.Assertions.*;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import association.GestionMembre;
import association.InformationPersonnelle;
import association.InterMembre;
import association.Membre;

/**
 * Tests JUnit de la classe {@link association.GestionMembre}
 * 
 * @author Gwendal Le Tareau
 * @see association.GestionMembre
 *
 */
class TestGestionMembre {
  
  /**
   * Déclaration de GestionMembre
   */
  private GestionMembre gestionM;
  
  
  /**
   * Liste de membres
   */
  Set<InterMembre> listeMembres;
  
  /**
   * Membre président
   */
  InterMembre mPresident;
  
  /**
   * Liste d'informations personnelles
   */
  InformationPersonnelle[] listeInfoPerso;
  
  
  /**
   * 
   * @throws Exception
   */
  @BeforeEach
  void setUp() throws Exception {
    
    listeMembres = new HashSet<InterMembre>();
    
    // Instanciation du président / définition de ses information personnelles /
    // ajout dans la liste des membres.
    InterMembre mPresident = new Membre();
    
    mPresident.definirInformationPersonnelle(new InformationPersonnelle(
        "Skywalker", "Luke", "Planète Tatooine", 20));
    
    listeMembres.add(mPresident);
    
    
    
    listeInfoPerso = new InformationPersonnelle[] {
        new InformationPersonnelle("Skywalker", "Anakin", "Planète Tatooine",
            50),
        new InformationPersonnelle("Organa", "Leia", "Planète Tatooine", 30),
        new InformationPersonnelle("Kenobi", "Obi-Wan", "Planète Tatooine",
            40),};
    
    // Ajoute des membres dans la liste en utilisant les informations
    // personnelles créées ci-dessus.
    for (InformationPersonnelle ip : listeInfoPerso) {
      InterMembre m = new Membre();
      m.definirInformationPersonnelle(ip);
      
      listeMembres.add(m);
    }
    
    
    /*
     * System.out.println("\n\n");
     * System.out.println("=========================");
     * System.out.println("toString :");
     * System.out.println("=========================");
     * System.out.println("Mvide :\n" + gestionMvide.toString());
     * System.out.println("-------------------------");
     * System.out.println("Mmembres :\n" + gestionMmembres.toString());
     * System.out.println("-------------------------");
     * System.out.println("Mpresident :\n" + gestionMpresident.toString());
     * System.out.println("=========================");
     */
  }
  
  
  
  /**
   * Vérifie que les membres entrés dans le constructeurs sont bien ajoutés à la
   * liste des membres de l'association.
   */
  @Test
  void testConstructeurListeMembres() {
    gestionM = new GestionMembre(listeMembres);
    assertEquals(gestionM.ensembleMembres().size(), listeMembres.size());
  }
  
  /**
   * Vérifie que le membre entré dans le constructeur est bien désigné président
   * de l'association.
   */
  @Test
  void testConstructeurPresident() {
    gestionM = new GestionMembre(listeMembres, mPresident);
    assertEquals(gestionM.president(), mPresident);
  }
  
  /**
   * Vérifie que le membre entré dans la méthode est bien désigné président de
   * l'ssociation.
   */
  @Test
  void testDesignationPresident() {
    gestionM = new GestionMembre(listeMembres);
    
    assertTrue(gestionM.designerPresident(mPresident));
    assertEquals(gestionM.president(), mPresident);
  }
  
  
  /**
   * Vérifie qu'un membre entré dans le méthode est bien supprimé de la liste
   * des membres de l'association.
   */
  @Test
  void testAjoutMembre() {
    
    gestionM = new GestionMembre(listeMembres);
    
    int nbMembreAvantAjout = gestionM.ensembleMembres().size();
    
    InterMembre m = new Membre();
    m.definirInformationPersonnelle(
        new InformationPersonnelle("TestNom", "TestPrenom", "TestAdresse", 20));
    
    assertTrue(gestionM.ajouterMembre(m));
    
    assertTrue(gestionM.ensembleMembres().contains(m));
    System.out
        .println("aTrue cont m : " + gestionM.ensembleMembres().contains(m));
    
    assertTrue(gestionM.ensembleMembres().size() == nbMembreAvantAjout + 1);
    
  }
  
  /**
   * Vérifie qu'un membre entré dans la méthode est bien supprimé de la liste
   * des membres de l'association.
   */
  @Test
  void testSuppressionMembre() {
    
    gestionM = new GestionMembre(listeMembres);
    
    int nbMembreAvantSup = gestionM.ensembleMembres().size();
    
    
    InterMembre m = new Membre();
    m.definirInformationPersonnelle(listeInfoPerso[0]);
    
    assertTrue(gestionM.supprimerMembre(m));
    
    assertTrue(gestionM.ensembleMembres().size() == nbMembreAvantSup - 1);
    
  }
  
  
  
}
