package association;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


/**
 * Description d'un membre d'une association : nom, prénom, âge et adresse.
 *
 * @author Maxime André
 *
 */
public class Membre implements InterMembre {
  
  /**
   * Informations personnelles du membre.
   */
  private InformationPersonnelle infoperso;
  
  /**
   * Liste des évènements du membre.
   */
  private List<Evenement> listevent;
  
  /**
   * Créer un membre en initialisant ses informations personnelles, sa liste
   * d'évènements, sa liste d'évènements à venir ainsi que la liste de membres à
   * null.
   */
  public Membre() {
    infoperso = null;
    listevent = new ArrayList<Evenement>();
  }
  
  @Override
  public List<Evenement> ensembleEvenements() {
    // Retourne la liste des évènements du membre
    return listevent;
  }
  
  @Override
  public List<Evenement> ensembleEvenementsAvenir() {
    // Si la liste n'est pas vide
    if (this.listevent != null) {
      // Crée une liste pour stocker les évènements du membre à venir
      List<Evenement> eventcoming = new ArrayList<Evenement>();
      // Crée un objet "LocalDateTime" pour avoir la date courante
      LocalDateTime now = LocalDateTime.now();
      
      // Pour chaque évènement de la liste d'évènements du membre
      for (Evenement e : listevent) {
        /*
         * On compare la date de l'évènement à la date courante. Si la date de
         * l'évènement est après la date courante alors l'évèvenment n'a pas eu
         * lieu, on l'ajoute donc à la liste des évènements à venir
         */
        if (now.isBefore(e.getDate())) {
          eventcoming.add(e);
        }
      }
      
      // Retourne la liste des évènements du membre à venir
      return eventcoming;
    }
    
    // Sinon retourner la liste
    return listevent;
  }
  
  @Override
  public void definirInformationPersonnelle(InformationPersonnelle info) {
    // Définition des informations personnelles du membre
    infoperso = info;
  }
  
  @Override
  public InformationPersonnelle getInformationPersonnelle() {
    // Retourne les informations personnelles du membre
    return getInfoperso();
  }
  
  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    
    if (obj == null) {
      return false;
    }
    
    if (!(obj instanceof Membre)) {
      return false;
    }
    
    Membre mbr = (Membre) obj;
    return this.getInfoperso().getNom() == mbr.getInfoperso().getNom()
        && this.getInfoperso().getPrenom() == mbr.getInfoperso().getPrenom()
        && this.getInfoperso().getAge() == mbr.getInfoperso().getAge()
        && this.getInfoperso().getAdresse() == mbr.getInfoperso().getAdresse();
  }
  
  @Override
  public String toString() {
    return this.getInfoperso().toString();
  }

  public InformationPersonnelle getInfoperso() {
    return infoperso;
  }
}
