package association;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;


/**
 * Gestionnaire des membres de l'association (ajout, suppression) et de son
 * président (désignation).
 * 
 * @author gwendal
 *
 */
public class GestionMembre implements InterGestionMembres {
  
  
  
  /**
   * Liste des membres de l'association.
   */
  private Set<InterMembre> listeMembres;
  
  /**
   * Membre président
   */
  private InterMembre president;
  
  
  
  // -------------------------
  
  
  
  /**
   * Constructeur de GestionMembre
   */
  public GestionMembre() {
    super();
    this.listeMembres = new HashSet<InterMembre>();
  }
  
  /**
   * Constructeurs de GestionMembre en initialisant la liste des membres avec
   * une liste fournie en paramètre.
   */
  public GestionMembre(Set<InterMembre> listeMembres) {
    super();
    
    this.listeMembres = listeMembres;
  }
  
  /**
   * Constructeurs de GestionMembre en initialisant la liste des membres et le
   * président (si présent dans la liste) avec une liste et le président founis
   * en paramètre.
   */
  public GestionMembre(Set<InterMembre> membres, InterMembre president) {
    this(membres);
    
    if (membres.contains(president))
      this.president = president;
  }
  
  
  
  // -------------------------
  
  
  
  @Override
  public boolean ajouterMembre(InterMembre membre) {
    
    // Vérification de la présence ou non du membre.
    for (InterMembre m : this.listeMembres) {
      if (m.equals(membre)) {
        return false;
      }
    }
    
    this.listeMembres.add(membre);
    return true;
  }
  
  @Override
  public boolean supprimerMembre(InterMembre membre) {
    
    for (InterMembre m : this.listeMembres) {
      if (m.equals(membre)) {
        this.listeMembres.remove(m);
        return true;
      }
    }
    
    return false;
    
  }
  
  @Override
  public boolean designerPresident(InterMembre membre) {
    
    if (!this.listeMembres.contains(membre))
      return false;
    
    this.president = membre;
    return true;
  }
  
  @Override
  public Set<InterMembre> ensembleMembres() {
    // TODO Auto-generated method stub
    return this.listeMembres;
  }
  
  @Override
  public InterMembre president() {
    return this.president;
  }
  
  
  
  @Override
  public String toString() {
    String toReturn = "";
    if (this.president != null) {
      toReturn +=
          "Président de l'association : " + this.president.toString() + "\n\n";
    }
    
    toReturn += "Liste des membres :";
    
    
    
    for (InterMembre m : this.listeMembres) {
      toReturn += "\n\t- " + m.toString();
      
      if (m.equals(this.president)) {
        toReturn += " (Président)";
      }
    }
    
    return toReturn;
  }
  
  
}
