package association;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * Gestionnaire de l'association, implément les actions de gestion de
 * l'association.
 *
 * @author Lou Tinevez
 * @version 1
 */
public class GestionAssociation implements InterGestionAssociation {
  
  /**
   * Référence du gestionnaire d'évenements utilisé.
   */
  private InterGestionEvenements gestionEvenements;
  
  /**
   * Référence du gestionnaire de membres utilisé.
   */
  private InterGestionMembres gestionMembres;
  
  /**
   * Crée le gestionnaire d'association et initialise ses 2 gestionnaires à
   * null.
   */
  public GestionAssociation() {
    this.gestionEvenements = null;
    this.gestionMembres = null;
  }
  
  /**
   * Renvoi le gestionnaire de membre utilisé.
   *
   * @return le gestionnaire de membre
   */
  public InterGestionMembres getGestionMembres() {
    return this.gestionMembres;
  }
  
  /**
   * Renvoi le gestionnaire d'évènements.
   *
   * @return le gestionnaire d'évènements
   */
  public InterGestionEvenements getGestionEvenements() {
    return this.gestionEvenements;
  }
  
  @Override
  public InterGestionEvenements gestionnaireEvenements() {
    if (this.gestionEvenements == null) {
      this.gestionEvenements = new GestionEvenements();
    }
    return this.gestionEvenements;
  }
  
  @Override
  public InterGestionMembres gestionnaireMembre() {
    if (this.gestionMembres == null) {
      this.gestionMembres = new GestionMembre();
    }
    return this.gestionMembres;
  }
  
  @Override
  public void sauvegarderDonnees(String nomFichier) throws IOException {
    ObjectOutputStream oos =
        new ObjectOutputStream(new FileOutputStream(nomFichier));
    oos.writeObject(this.gestionEvenements.ensembleEvenements());
    oos.writeObject(this.gestionMembres.ensembleMembres());
    oos.close();
  }
  
  @SuppressWarnings("unchecked")
  @Override
  public void chargerDonnees(String nomFichier) throws IOException {
    ObjectInputStream ois =
        new ObjectInputStream(new FileInputStream(nomFichier));
    ArrayList<Evenement> evenements = null;
    Set<InterMembre> membres = null;
    
    try {
      evenements = (ArrayList<Evenement>) ois.readObject();
    } catch (ClassNotFoundException | IOException e) {
      ois.skip(1);
      e.printStackTrace();
    }
    
    try {
      membres = (Set<InterMembre>) ois.readObject();
    } catch (ClassNotFoundException | IOException e) {
      ois.skip(1);
      e.printStackTrace();
    }
    
    this.gestionMembres = new GestionMembre(membres);
    this.gestionEvenements = new GestionEvenements(evenements);
    ois.close();
  }
  
}
