package scolarite;

import java.util.Arrays;

public class Promotion {
	
	String nom;
	Etudiant[] etudiants;
	
	
	public Promotion(String nom) {
		this.nom = nom;
		this.etudiants = new Etudiant[0];
	}
	
	public void addEtudiant(Etudiant e)
	{
		Etudiant[] nouvEtudiants = Arrays.copyOf(etudiants , etudiants.length+1);
		nouvEtudiants[nouvEtudiants.length-1] = e;
	}

	// Renvoie false si e n'est pas dans la promo, sinon true.
	public boolean delE(Etudiant e)
	{
		if (e.promo != this)
			return false;
		else
		{
			int ie = 0;
			while (this.etudiants[ie] != e)
				ie++;
			
			this.etudiants[ie] = this.etudiants[this.etudiants.length - 1];
			this.etudiants = Arrays.copyOf(this.etudiants, this.etudiants.length-1);
			
			e.promo = null;

			return true;
		}
			
	}

	
	
	@Override
	public String toString() {
		String res = this.nom;
		
		for (Etudiant e : this.etudiants)
		{
			res += " [" + e + "]"; // implicitement e.toString()
		}
		
		return res;
	}

}
