/* programme de recherche auto-adaptative */
// question 1

#include <stdio.h>
#include <stdlib.h>

#include "rech_auto.h"

#define N 15

typedef int MonTableau[N];

MonTableau elemA, elemB, elemC, cpt;


/*--------------------------------------------------------------------------
  Utilitaire de visualisation des tableaux
  --------------------------------------------------------------------------*/

void affichetab(MonTableau t)
{
    printf("[ %d", t[0]);

    for (int i = 1 ; i < N ; i++)
    {
        printf(", %d", t[i]);
    }
    
    printf(" ]");
}


/*--------------------------------------------------------------------------
  Initialisation des trois tableaux elemA, elemB, elemC et cpt
  --------------------------------------------------------------------------*/

void init_elem(void)
{
    for (int i = 0 ; i < N ; i++)
    {
        elemA[i] = elemB[i] = elemC[i] = i;
        cpt[i] = 0;
    }
}


/*--------------------------------------------------------------------------
  Recherche d'elements dans le tableau elemA
  --------------------------------------------------------------------------*/

int recherche_A(int cle)
{
    int i = 0;
    while (i < N && elemA[i]!=cle) i++;
        
    if (i > 0 && elemA[i] == cle)
    {
        int tmp = elemA[i];
        elemA[i] = elemA[i-1];
        elemA[i-1] = tmp;
    }
    
    return i+1;
}


/*--------------------------------------------------------------------------
  Recherche d'elements dans le tableau elemB
  --------------------------------------------------------------------------*/

int recherche_B(int cle)
{
    int i = 0, cmp;
    while (i < N && elemB[i]!=cle) i++;
    
    cmp = i+1;
    if (i > 0 && elemB[i] == cle)
    {
        for (int j = i ; j > 0 ; j--)
        {
            elemB[j] = elemB[j-1];
            
//            int tmp = elemB[i];
//            elemB[i] = elemB[i-1];
//            elemB[i-1] = tmp;
        }
        elemB[0] = cle;
    }
    
    return 0;
}


/*--------------------------------------------------------------------------
  Recherche d'elements dans le tableau elemC
  --------------------------------------------------------------------------*/

int recherche_C(int cle)
{
    int i = 0, cmp;
    while (i < N && elemC[i]!=cle) i++;

    cmp = i+1;
    if (elemC[i] == cle)
    {
        cpt[i]++;
        int cpt_cle = cpt[i];

        while (i > 0 && cpt_cle > cpt[i-1])
        {
            cpt[i] = cpt[i-1];
            elemC[i] = elemC[i-1];
            i--;
        }
        cpt[i] = cpt_cle;
        elemC[i] = cle;
            
    }
    
    return cmp;
}


/*--------------------------------------------------------------------------
  Corps du programme
  --------------------------------------------------------------------------*/

int nomain(void)
{
    int cle, temp;

    init_elem();
    printf("\nCle a rechercher (0 pour arreter) ? ");
    scanf("%d", &cle);
    while (cle != 0) {
//        temp = recherche_A(cle);
//        printf(" \nElem-a :"); affichetab(elemA);
//
//        temp = recherche_B(cle);
//        printf(" \nElem-b :"); affichetab(elemB);
        
        temp = recherche_C(cle);
        printf(" \nElem-c :"); affichetab(elemC);
        printf(" \nCpt    :"); affichetab(cpt);
        
        printf("\nCle a rechercher (0 pour arreter) ? ");
        scanf("%d", &cle);
    }
  
    return 0;
}




int main(void)
{
    int nb_cle, cle, temp;
    
    init_env_psal(0);

    init_elem();
    printf("\nNombre de clé à générer (0 pour arreter) ? ");
    scanf("%d", &nb_cle);
    while (nb_cle != 0) {
        
        for (int i = 0 ; i < nb_cle ; i++)
        {
            cle = tirage_cle_env_psal(0);
            
            temp = recherche_A(cle);
            printf(" \nElem-a :"); affichetab(elemA);

            temp = recherche_B(cle);
            printf(" \nElem-b :"); affichetab(elemB);
            
            temp = recherche_C(cle);
            printf(" \nElem-c :"); affichetab(elemC);
            printf(" \nCpt    :"); affichetab(cpt);
            
        }
        printf("\nNombre de clé à générer (0 pour arreter) ? ");
        scanf("%d", &nb_cle);
        
    }
  
    return 0;
}

