/*
 * Decompiled with CFR 0.152.
 */
package com.controllers;

import com.dtos.MembreDto;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/membres"})
@CrossOrigin(origins={"http://localhost:8000"})
public class MembreController {
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${API.MEMBRE.HOSTNAME}")
    private String hostnameApiMembre;
    @Value(value="${API.MEMBRE.PORT}")
    private String portApiMembre;
    private String urlMembre;

    @PostConstruct
    public void init() {
        this.urlMembre = "http://" + this.hostnameApiMembre + ":" + this.portApiMembre + "/membres/";
    }

    @GetMapping
    public List<MembreDto> getMembres() {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlMembre, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<MembreDto>>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API Lieu");
        }
        return (List)responseEntity.getBody();
    }

    @PostMapping
    public MembreDto saveMembre(@RequestBody MembreDto membreDto) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.urlMembre, (Object)membreDto, MembreDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.CREATED) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (MembreDto)responseEntity.getBody();
    }

    @GetMapping(value={"/{membresId}"})
    public MembreDto membreDto(@PathVariable Long membresId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlMembre + "/" + membresId, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<MembreDto>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API Lieu");
        }
        return (MembreDto)responseEntity.getBody();
    }

    @PutMapping(value={"/{membresId}"})
    public MembreDto updateMembreDto(@RequestBody MembreDto membreDto, @PathVariable Long membresId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlMembre + "/" + membresId, HttpMethod.PUT, new HttpEntity((Object)membreDto), MembreDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (MembreDto)responseEntity.getBody();
    }

    @DeleteMapping(value={"/{membresId}"})
    public Boolean deleteMembre(@PathVariable Long membresId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlMembre + "/" + membresId, HttpMethod.DELETE, null, Boolean.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du lieu avec l'ID : " + membresId);
        }
        return (Boolean)responseEntity.getBody();
    }
}

