/*
 * Decompiled with CFR 0.152.
 */
package com.controllers;

import com.dtos.LieuDto;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/lieux"})
@CrossOrigin(origins={"http://localhost:8000"})
public class LieuController {
    @Value(value="${API.LIEU.HOSTNAME}")
    private String hostnameApiLieu;
    @Value(value="${API.LIEU.PORT}")
    private String portApiLieu;
    private String urlLieu;
    private RestTemplate restTemplate = new RestTemplate();

    @PostConstruct
    public void init() {
        this.urlLieu = "http://" + this.hostnameApiLieu + ":" + this.portApiLieu + "/lieux";
    }

    @GetMapping
    public List<LieuDto> getLieu() {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlLieu, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<LieuDto>>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API Lieu");
        }
        return (List)responseEntity.getBody();
    }

    @PostMapping
    public LieuDto saveLieu(@RequestBody LieuDto lieuDto) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.urlLieu, (Object)lieuDto, LieuDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (LieuDto)responseEntity.getBody();
    }

    @GetMapping(value={"/{lieuxId}"})
    public LieuDto lieuDto(@PathVariable Long lieuxId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlLieu + "/" + lieuxId, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<LieuDto>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API Lieu");
        }
        return (LieuDto)responseEntity.getBody();
    }

    @PutMapping(value={"/{lieuxId}"})
    public LieuDto updateLieuDto(@PathVariable Long lieuxId, @RequestBody LieuDto lieuDto) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlLieu + "/" + lieuxId, HttpMethod.PUT, new HttpEntity((Object)lieuDto), LieuDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (LieuDto)responseEntity.getBody();
    }

    @DeleteMapping(value={"/{lieuxId}"})
    public Boolean deleteLieux(@PathVariable Long lieuxId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlLieu + "/" + lieuxId, HttpMethod.DELETE, null, Boolean.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du lieu avec l'ID : " + lieuxId);
        }
        return (Boolean)responseEntity.getBody();
    }
}

