/*
 * Decompiled with CFR 0.152.
 */
package com.controllers;

import com.dtos.CommentaireDto;
import com.dtos.EvenementDto;
import com.dtos.LieuDto;
import com.dtos.MembreDto;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/events"})
@CrossOrigin(origins={"http://localhost:8000"})
public class EvenementController {
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${API.EVENEMENT.PORT}")
    private String portApiEvenement;
    @Value(value="${API.EVENEMENT.HOSTNAME}")
    private String hostnameApiEvenement;
    private String urlEvenement;

    @PostConstruct
    public void init() {
        this.urlEvenement = "http://" + this.hostnameApiEvenement + ":" + this.portApiEvenement + "/events";
    }

    @GetMapping
    public List<EvenementDto> getAllEvent() {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EvenementDto>>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API commentaire");
        }
        return (List)responseEntity.getBody();
    }

    @PostMapping
    public EvenementDto addEvent(@RequestBody EvenementDto evenementDto) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.urlEvenement, (Object)evenementDto, EvenementDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (EvenementDto)responseEntity.getBody();
    }

    @GetMapping(value={"{eventId}"})
    public EvenementDto getEventById(@PathVariable int eventId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement + "/" + eventId, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<EvenementDto>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API Lieu");
        }
        return (EvenementDto)responseEntity.getBody();
    }

    @PutMapping(value={"{eventId}"})
    public CommentaireDto updateEventById(@PathVariable int eventId, @RequestBody CommentaireDto commentaireDto) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement + "/" + eventId, HttpMethod.PUT, new HttpEntity((Object)commentaireDto), CommentaireDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (CommentaireDto)responseEntity.getBody();
    }

    @DeleteMapping(value={"{eventId}"})
    public Boolean deleteEventById(@PathVariable int eventId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement + "/" + eventId, HttpMethod.DELETE, null, Boolean.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du lieu avec l'ID : " + eventId);
        }
        return (Boolean)responseEntity.getBody();
    }

    @GetMapping(value={"{eventId}/membres"})
    public List<EvenementDto> getAllMembreFromEventById(@PathVariable Long eventId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement + "/" + eventId + "/membres", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EvenementDto>>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API Lieu");
        }
        return (List)responseEntity.getBody();
    }

    @PutMapping(value={"{eventId}/membres"})
    public MembreDto signUpdateMembreInfoById(@PathVariable Long eventId, @RequestBody MembreDto membreDto) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement + "/" + eventId + "/membres", HttpMethod.PUT, new HttpEntity((Object)membreDto), MembreDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (MembreDto)responseEntity.getBody();
    }

    @PutMapping(value={"{eventId}/location"})
    public LieuDto setLocationToEventById(@PathVariable Long eventId, @RequestBody LieuDto lieuDto) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement + "/" + eventId + "/location", HttpMethod.PUT, new HttpEntity((Object)lieuDto), LieuDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API Lieu");
        }
        return (LieuDto)responseEntity.getBody();
    }

    @DeleteMapping(value={"{eventId}/location"})
    public Boolean deleteLocationOfEventById(@PathVariable Long eventId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlEvenement + "/" + eventId + "/location", HttpMethod.DELETE, null, Boolean.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du lieu avec l'ID : " + eventId);
        }
        return (Boolean)responseEntity.getBody();
    }
}

