/*
 * Decompiled with CFR 0.152.
 */
package com.services.impl;

import com.dtos.LieuDto;
import com.entities.Lieu;
import com.repositories.LieuRepository;
import com.services.LieuService;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="lieuService")
public class LieuServiceImpl
implements LieuService {
    private final LieuRepository lieuRepository;

    public LieuServiceImpl(LieuRepository lieuRepository) {
        this.lieuRepository = lieuRepository;
    }

    public LieuDto saveLieu(LieuDto lieuDto) {
        Lieu lieu = this.lieuDtoToEntity(lieuDto);
        lieu = (Lieu)this.lieuRepository.save((Object)lieu);
        return this.lieuEntityToDto(lieu);
    }

    public LieuDto getLieuById(Long lieuId) {
        Lieu lieu = (Lieu)this.lieuRepository.findById((Object)lieuId).orElseThrow(() -> new EntityNotFoundException("Lieux not found"));
        return this.lieuEntityToDto(lieu);
    }

    public LieuDto updateLieu(Long lieuId, LieuDto lieuDto) {
        if (!this.lieuRepository.existsById((Object)lieuId)) {
            throw new EntityNotFoundException("Lieux not found");
        }
        Lieu lieu = this.lieuDtoToEntity(lieuDto);
        lieu.setId(lieuId);
        this.lieuRepository.save((Object)lieu);
        return this.lieuEntityToDto(lieu);
    }

    public boolean deleteLieu(Long lieuId) {
        this.lieuRepository.deleteById((Object)lieuId);
        return true;
    }

    public List<LieuDto> getAllLieu() {
        ArrayList<LieuDto> lieuDtos = new ArrayList<LieuDto>();
        List lieus = this.lieuRepository.findAll();
        lieus.forEach(lieu -> lieuDtos.add(this.lieuEntityToDto(lieu)));
        return lieuDtos;
    }

    private LieuDto lieuEntityToDto(Lieu lieu) {
        LieuDto lieuDto = new LieuDto();
        lieuDto.setId(lieu.getId());
        lieuDto.setName(lieu.getName());
        lieuDto.setAddress(lieu.getAddress());
        return lieuDto;
    }

    private Lieu lieuDtoToEntity(LieuDto lieuDto) {
        Lieu lieu = new Lieu();
        lieu.setName(lieuDto.getName());
        lieu.setAddress(lieuDto.getAddress());
        lieu.setId(lieuDto.getId());
        return lieu;
    }
}

