/*
 * Decompiled with CFR 0.152.
 */
package com.controllers;

import com.dtos.CommentaireDto;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/commentaire"})
public class CommentaireController {
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${API.COMMENTAIRE.HOSTNAME}")
    private String hostnameApiCommentaire;
    @Value(value="${API.COMMENTAIRE.PORT}")
    private String portApiCommentaire;
    private String urlCommentaire;

    @PostConstruct
    public void init() {
        this.urlCommentaire = "http://" + this.hostnameApiCommentaire + ":" + this.portApiCommentaire + "/commentaire";
    }

    @GetMapping
    public List<CommentaireDto> getAllCommentaire() {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlCommentaire, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<CommentaireDto>>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API commentaire");
        }
        return (List)responseEntity.getBody();
    }

    @PostMapping
    public CommentaireDto saveCommentaire(@RequestBody CommentaireDto commentaireDto) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.urlCommentaire, (Object)commentaireDto, CommentaireDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API commentaire");
        }
        return (CommentaireDto)responseEntity.getBody();
    }

    @GetMapping(value={"evenement/{evenementId}"})
    public List<CommentaireDto> getAllCommentaireFromEvement(@PathVariable Long evenementId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlCommentaire + "/evenement/" + evenementId, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<CommentaireDto>>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API commentaire");
        }
        return (List)responseEntity.getBody();
    }

    @GetMapping(value={"{commentaireId}"})
    public CommentaireDto getCommentaireById(@PathVariable Long commentaireId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlCommentaire + "/" + commentaireId, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<CommentaireDto>(){}, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration des lieux depuis l'API commentaire");
        }
        return (CommentaireDto)responseEntity.getBody();
    }

    @DeleteMapping(value={"{commentaireId}"})
    public Boolean deleteCommentaireById(@PathVariable Long commentaireId) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlCommentaire + "/" + commentaireId, HttpMethod.DELETE, null, Boolean.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du commentaire avec l'ID : " + commentaireId);
        }
        return (Boolean)responseEntity.getBody();
    }

    @PutMapping(value={"{commentaireId}"})
    public CommentaireDto updateCommentaire(@PathVariable Long commentaireId, @RequestBody CommentaireDto commentaireDto) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.urlCommentaire + "/" + commentaireId, HttpMethod.PUT, new HttpEntity((Object)commentaireDto), CommentaireDto.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la cr\u00e9ation d'un nouveau lieu via l'API commentaire");
        }
        return (CommentaireDto)responseEntity.getBody();
    }
}

