package fonction;

import static com.mongodb.MongoClientSettings.getDefaultCodecRegistry;
import static com.mongodb.client.model.Filters.eq;
import static org.bson.codecs.configuration.CodecRegistries.fromProviders;
import static org.bson.codecs.configuration.CodecRegistries.fromRegistries;

import java.util.ArrayList;
import java.util.List;

import com.mongodb.client.model.Filters;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.types.ObjectId;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import static com.mongodb.client.model.Filters.and;

import donnees.Commentaire;

public class UtiliseCommentaire {
    private ConnectionString connectionString;
    private MongoClient mongoClient;
    MongoDatabase database;
    MongoCollection<Commentaire> collection;
    public UtiliseCommentaire() {
    	CodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).build();
		CodecRegistry pojoCodecRegistry = fromRegistries(getDefaultCodecRegistry(), fromProviders(pojoCodecProvider));
    	connectionString = new ConnectionString("mongodb://root:root@mongodb:27017");
    	mongoClient = MongoClients.create(connectionString);
    	database = mongoClient.getDatabase("Commentaire").withCodecRegistry(pojoCodecRegistry);
    	System.out.println("Connexion �tablie\n");

    	collection = database.getCollection("commentaire", Commentaire.class);
    	
    	
    }

    public void ajouterCommentaire(Commentaire commentaire) {
        collection.insertOne(commentaire);
    }

    public List<Commentaire> getListeCommentaires() {

        return collection.find().into(new ArrayList<>());
    }

    public List<Commentaire> getListeCommentairesByMembre(Integer membreId) {
        return collection.find(eq("auteurId", membreId)).into(new ArrayList<>());
    }
    public List<Commentaire> getListeCommentairesByEvenement(Integer evenementId) {
        return collection.find(eq("evenementId", evenementId)).into(new ArrayList<>());
    }
    public List<Commentaire> getListeCommentairesByEvenementAndMembre(Integer evenementId, Integer membreId) {
        return collection.find(and(eq("evenementId", evenementId), eq("auteurId", membreId))).into(new ArrayList<>());
    }

    public void supprimerCommentaire(String id) {
        if (ObjectId.isValid(id)) { // Vérifie si le format de l'ID est valide
            ObjectId objectId = new ObjectId(id); // Convertit la chaîne en ObjectId
            collection.deleteOne(Filters.eq("_id", objectId)); // Utilise _id pour la suppression
        } else {
            System.out.println("L'identifiant fourni n'est pas valide.");
        }
    }

    public void mettreAJourCommentaire(Commentaire commentaire) {
    	collection.replaceOne(eq("_id", commentaire.getId()), commentaire);
    }

}
