<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Liste des Commentaires</title>
</head>
<body>
<h2>Commentaires</h2>
<c:forEach items="${commentaires}" var="commentaire">
    <h4>Commentaire ID: ${commentaire.id.toHexString()}</h4> <!-- Utilisation de toHexString pour convertir ObjectId en String -->
    <p>
        <b>Texte du commentaire :</b> ${commentaire.texteCommentaire}
    </p>
    <p>
        <b>Date :</b> <fmt:formatDate value="${commentaire.date}" pattern="dd/MM/yyyy HH:mm:ss" />
    </p>
    <p>
        <b>ID de l'événement :</b> ${commentaire.evenement} <!-- Supposant que evenement est un ID maintenant -->
    </p>
    <p>
        <b>ID du membre :</b> ${commentaire.membre} <!-- Supposant que membre est un ID maintenant -->
    </p>
</c:forEach>

</body>
</html>
