package io.swagger.api;

import io.swagger.model.LightingSummary;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2024-03-12T14:21:22.106090110Z[GMT]")
@RestController
public class LightingSummaryApiController implements LightingSummaryApi {

    private static final Logger log = LoggerFactory.getLogger(LightingSummaryApiController.class);

    private final ObjectMapper objectMapper;

    private final HttpServletRequest request;

    @org.springframework.beans.factory.annotation.Autowired
    public LightingSummaryApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    public ResponseEntity<LightingSummary> getLightingSummary() {
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity<LightingSummary>(objectMapper.readValue("{\n  \"zoneStatus\" : [ {\n    \"level\" : 6,\n    \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\n    \"name\" : \"name\",\n    \"id\" : \"id\"\n  }, {\n    \"level\" : 6,\n    \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\n    \"name\" : \"name\",\n    \"id\" : \"id\"\n  } ],\n  \"zones\" : [ {\n    \"deviceType\" : \"dimmer\",\n    \"zone\" : \"zone\",\n    \"name\" : \"name\",\n    \"id\" : \"id\",\n    \"deviceId\" : 0\n  }, {\n    \"deviceType\" : \"dimmer\",\n    \"zone\" : \"zone\",\n    \"name\" : \"name\",\n    \"id\" : \"id\",\n    \"deviceId\" : 0\n  } ]\n}", LightingSummary.class), HttpStatus.NOT_IMPLEMENTED);
            } catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", e);
                return new ResponseEntity<LightingSummary>(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }

        return new ResponseEntity<LightingSummary>(HttpStatus.NOT_IMPLEMENTED);
    }

}
