# React

## JS

### Fonction fléchée (FF) vs. fonction classique (FC)

`return` implicite.

`add = (a, b) => a+b`
revient à
`add = (a, b) => return a+b`

### this (≈ Java)

``` JS
const person = {
    age: 45,
    getAge: function() {
        return this.age;
    }
}
```

``` JS
function foo() {
    console.log(this)
}
window.foo();
```

**`this` n'est pas utilisable avec des fonctions fléchées sauf si elle est dans une fonction classique.**

### arguments

```JS
function faz() {
    console.log(arguments);
}

const foz() {
    console.log(arguments);
}
```

`faz(1, 2, 3, 4, 5);` => `[1, 2, 3, 4, 5]`
`foz(1, 2, 3, 4, 5);` => `arguments is not defined`

### Spread operator (syntaxe de décomposition)

```JS
const array = [1, 2, 3];
console.log(...array); // => 1 2 3
```
```JS
const shallowArrayCopy = [...array, 4, 5, 6]
console.log(shallowArrayCopy) // => 1, 2, 3, 4, 5, 6
```
```JS
const array = [1, 2, 3, {a: 5}];
console.log(...array); // => 1 2 3 {a: 5}
array[3].a = 555;
console.log(...array); // => 1 2 3 {a: 555}
```
```JS
const str = "Le chat saute, le chien court.";
const strCopyArray = [...str];
console.log(strCopyArray); // => ['L', 'e', ' ', 'c', 'h', 'a', 't', ...]
```

### Destructuring

```JS
const userObj = {
  userName: "Karl"
  age: 44,
  country: "Germany"
}

const {country, age, userName} = userObj; // Les noms des constantes / variables et des attributs de l'objet doivent être les mêmes.
console.log(age, country, userName; // => 44 'Germany' 'Karl'

// Nom différent
const {userName: mainName, age: exactAge, country: origin} = userObj;
console.log(mainName); // => 'Karl'

// Valeur par défaut
const {country, sport = "Football", beverage = "Beer"} = userObj;
console.log(country, sport, beverage); // Germany Football Beer

// Nom différent et valeur par défaut
const {userName: mainName = "Hanz"} = userObj;
console.log(mainName); // Karl

// Affecter les props (attributs) d'un objets attendu en paramètre.
const numbers() = {
  num1: 50,
  num2: 100
}
function foo(numbers) {
  console.log(numbers);
  return numbers.num1 + numbers.num2
}
function foo2(num1, num2) {
  console.log(numbers);
  return num1 + num2
}

console.log(foo(numbers)); // => {num1: 50, num2: 100} => 150
console.log(foo2(numbers)); // => {num1: 50, num2: 100} => 150

// Tableau
const animals = ["cat", "dog", "mouse", "lion"];

const [cat, dog] = animals; // {} faire dans l'ordre // [] pas d'ordre
console.log(cat, dog); // => cat dog

let animal1, animal2;
[animal1, animal2] = animals
console.log(animal1, animal2); // => cat dog

// Valeur par défaut et ignorer des valeurs
const fruits = ["strawberry", "grapes" ,"banana", "apple"];

const [strawberry, grapes, , apple)] = fruits;
console.log(strawberry, grapes, apple); // => strawberry grapes apple

const [strawberry="red fruit"] = fruits;
console.log(strawberry); // => red fruit

// Affecter le reste d'un tableau

const [student, ...marks] = ["Adrien", 10, 10, 12, 14, 15, 9];
console.log(student, marks); // => Adrien [10, 10, 12, 14, 15, 9]

// Fonctionne avec les strings
```




**FIN**







| Hello  |   OK|
|---|---|
|   |   |







