<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>



<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Liste des Commentaires</title>
</head>
<body>
<h2>Commentaires</h2>
<c:forEach items="${commentaires}" var="commentaire">
    <h4>Commentaire ID: ${commentaire.id.toHexString()}</h4>
    <p>
        <b>Texte du commentaire :</b> ${commentaire.texte}
    </p>
    <p>
        <fmt:formatDate value="${commentaire.dateMessage}" pattern="dd/MM/yyyy HH:mm:ss" />
    </p>
    <p>
        <b>ID de l'événement :</b> ${commentaire.evenementId}
    </p>
    <p>
        <b>ID du membre :</b> ${commentaire.auteurId}
    </p>
</c:forEach>

</body>
</html>
