import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

import org.bson.types.ObjectId;

import donnees.Commentaire;
import fonction.UtiliseCommentaire;

/**
 * Servlet implementation class CommentaireServlet
 */
@WebServlet("/Commentaire")
public class CommentaireServlet extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private UtiliseCommentaire utiliseCommentaire;

    public CommentaireServlet() {
        super();
        // Initialisation de la connexion � la base de donn�es MongoDB dans le constructeur
        this.utiliseCommentaire = new UtiliseCommentaire();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        String operation = request.getParameter("operation");
        switch (operation) {
            case "listeCommentaire":
                listeCommentaires(request, response);
                break;
            case "listeCommentaireByMembre":
                listeCommentaireByMembre(request, response);
                break;
            case "listeCommentaireByEvenement":
                listeCommentairesByEvenement(request, response);
                break;
            case "listeCommentaireByEvenementEtMembre":
            	listeCommentairesByEvenementEtMembre(request, response);
                break;
            case "supprimerCommentaire":
                supprimerCommentaire(request, response);
                break;
            default:
                // Gestion des cas non reconnus ou erreur
                response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Op�ration non reconnue ou non support�e.");
                break;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        String operation = request.getParameter("operation");

        // R�ception des param�tres du formulaire
        try {
               Integer evenementId = Integer.valueOf(request.getParameter("evenementId"));
               Integer auteurId = Integer.valueOf(request.getParameter("auteurId"));
               String texte = request.getParameter("texte");

            // Cr�ation de l'objet Commentaire
            Commentaire commentaire = new Commentaire();
            // Remplissage des attributs du commentaire avec les donn�es re�ues
            commentaire.setEvenementId(evenementId);
            commentaire.setAuteurId(auteurId);
            commentaire.setTexte(texte);
            commentaire.setDateMessage(new Date()); // Fixe la date de mise à jour
            // Ici, vous pouvez �galement ajouter la gestion de la date du commentaire

            if ("cree".equals(operation)) {
            	System.out.println("test");
            	// Appel � la m�thode d'ajout de commentaire
            	this.utiliseCommentaire.ajouterCommentaire(commentaire);
            } else if ("modifier".equals(operation)) {
         	   ObjectId commentaireId = new ObjectId(request.getParameter("commentaireId"));
                commentaire.setId(commentaireId); // S'assure que l'ID ne change pas
            	this.utiliseCommentaire.mettreAJourCommentaire(commentaire);
            }
            // Redirection vers la liste des commentaires apr�s ajout
            response.sendRedirect("Commentaire?operation=listeCommentaire");
        } catch (NumberFormatException e) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Erreur dans les param�tres num�riques.");
        }
    }

    private void listeCommentaires(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        request.setAttribute("commentaires", utiliseCommentaire.getListeCommentaires());
        request.getRequestDispatcher("/afficheCommentaire.jsp").forward(request, response);
    }

    private void listeCommentaireByMembre(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        Integer auteurId = Integer.valueOf(request.getParameter("auteurId"));
        request.setAttribute("commentaires", utiliseCommentaire.getListeCommentairesByMembre(auteurId));
        request.getRequestDispatcher("/afficheCommentaire.jsp").forward(request, response);
    }

    private void listeCommentairesByEvenement(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
    	 Integer evenementId = Integer.valueOf(request.getParameter("evenementId"));
         request.setAttribute("commentaires", utiliseCommentaire.getListeCommentairesByEvenement(evenementId));
         request.getRequestDispatcher("/afficheCommentaire.jsp").forward(request, response);
    }
    private void listeCommentairesByEvenementEtMembre(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        Integer idEvenement = Integer.valueOf(request.getParameter("idEvenement"));
        Integer idMembre = Integer.valueOf(request.getParameter("idMembre"));
        
        request.setAttribute("commentaires", utiliseCommentaire.getListeCommentairesByEvenementAndMembre(idEvenement, idMembre));
        
        request.getRequestDispatcher("/afficheCommentaire.jsp").forward(request, response);
    }

    private void supprimerCommentaire(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        String idCommentaire = request.getParameter("commentaireId");
        utiliseCommentaire.supprimerCommentaire(idCommentaire);
        response.sendRedirect("Commentaire?operation=listeCommentaire");
    }
}
