/*
 * home-iot-api
 * The API for the EatBacon IOT project
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.54
 *
 * Do not edit the class manually.
 *
 */
import ApiClient from '../ApiClient';

/**
 * The TemperatueZoneStatus model module.
 * @module model/TemperatueZoneStatus
 * @version 1.0.0
 */
export default class TemperatueZoneStatus {
  /**
   * Constructs a new <code>TemperatueZoneStatus</code>.
   * status of a single zone
   * @alias module:model/TemperatueZoneStatus
   * @class
   * @param id {String} the unique identifier for the zone
   * @param value {Number} the temperature in the zone
   * @param timestamp {Date} the timestamp when the temperature was measured
   */
  constructor(id, value, timestamp) {
    this.id = id;
    this.value = value;
    this.timestamp = timestamp;
  }

  /**
   * Constructs a <code>TemperatueZoneStatus</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/TemperatueZoneStatus} obj Optional instance to populate.
   * @return {module:model/TemperatueZoneStatus} The populated <code>TemperatueZoneStatus</code> instance.
   */
  static constructFromObject(data, obj) {
    if (data) {
      obj = obj || new TemperatueZoneStatus();
      if (data.hasOwnProperty('id'))
        obj.id = ApiClient.convertToType(data['id'], 'String');
      if (data.hasOwnProperty('name'))
        obj.name = ApiClient.convertToType(data['name'], 'String');
      if (data.hasOwnProperty('value'))
        obj.value = ApiClient.convertToType(data['value'], 'Number');
      if (data.hasOwnProperty('units'))
        obj.units = ApiClient.convertToType(data['units'], 'String');
      if (data.hasOwnProperty('timestamp'))
        obj.timestamp = ApiClient.convertToType(data['timestamp'], 'Date');
    }
    return obj;
  }
}

/**
 * the unique identifier for the zone
 * @member {String} id
 */
TemperatueZoneStatus.prototype.id = undefined;

/**
 * the name of the zone
 * @member {String} name
 */
TemperatueZoneStatus.prototype.name = undefined;

/**
 * the temperature in the zone
 * @member {Number} value
 */
TemperatueZoneStatus.prototype.value = undefined;

/**
 * Allowed values for the <code>units</code> property.
 * @enum {String}
 * @readonly
 */
TemperatueZoneStatus.UnitsEnum = {
  /**
   * value: "celsius"
   * @const
   */
  celsius: "celsius",

  /**
   * value: "fahrenheit"
   * @const
   */
  fahrenheit: "fahrenheit"
};
/**
 * the temperature units
 * @member {module:model/TemperatueZoneStatus.UnitsEnum} units
 * @default 'fahrenheit'
 */
TemperatueZoneStatus.prototype.units = 'fahrenheit';

/**
 * the timestamp when the temperature was measured
 * @member {Date} timestamp
 */
TemperatueZoneStatus.prototype.timestamp = undefined;

