/*
 * home-iot-api
 * The API for the EatBacon IOT project
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.54
 *
 * Do not edit the class manually.
 *
 */
import ApiClient from '../ApiClient';
import ForecastTemperature from './ForecastTemperature';
import WeatherForecast from './WeatherForecast';

/**
 * The Forecast model module.
 * @module model/Forecast
 * @version 1.0.0
 */
export default class Forecast {
  /**
   * Constructs a new <code>Forecast</code>.
   * @alias module:model/Forecast
   * @class
   */
  constructor() {
  }

  /**
   * Constructs a <code>Forecast</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/Forecast} obj Optional instance to populate.
   * @return {module:model/Forecast} The populated <code>Forecast</code> instance.
   */
  static constructFromObject(data, obj) {
    if (data) {
      obj = obj || new Forecast();
      if (data.hasOwnProperty('date'))
        obj._date = ApiClient.convertToType(data['date'], 'Date');
      if (data.hasOwnProperty('pressure'))
        obj.pressure = ApiClient.convertToType(data['pressure'], 'Number');
      if (data.hasOwnProperty('humidity'))
        obj.humidity = ApiClient.convertToType(data['humidity'], 'Number');
      if (data.hasOwnProperty('windSpeed'))
        obj.windSpeed = ApiClient.convertToType(data['windSpeed'], 'Number');
      if (data.hasOwnProperty('clouds'))
        obj.clouds = ApiClient.convertToType(data['clouds'], 'Number');
      if (data.hasOwnProperty('temperature'))
        obj.temperature = ForecastTemperature.constructFromObject(data['temperature']);
      if (data.hasOwnProperty('weather'))
        obj.weather = WeatherForecast.constructFromObject(data['weather']);
    }
    return obj;
  }
}

/**
 * @member {Date} _date
 */
Forecast.prototype._date = undefined;

/**
 * @member {Number} pressure
 */
Forecast.prototype.pressure = undefined;

/**
 * @member {Number} humidity
 */
Forecast.prototype.humidity = undefined;

/**
 * @member {Number} windSpeed
 */
Forecast.prototype.windSpeed = undefined;

/**
 * @member {Number} clouds
 */
Forecast.prototype.clouds = undefined;

/**
 * @member {module:model/ForecastTemperature} temperature
 */
Forecast.prototype.temperature = undefined;

/**
 * @member {module:model/WeatherForecast} weather
 */
Forecast.prototype.weather = undefined;

