/*
 * home-iot-api
 * The API for the EatBacon IOT project
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.54
 *
 * Do not edit the class manually.
 *
 */
import ApiClient from "../ApiClient";
import ApiResponse from '../model/ApiResponse';
import ForecastResponse from '../model/ForecastResponse';
import HeaterState from '../model/HeaterState';
import TemperatueZoneStatus from '../model/TemperatueZoneStatus';
import TemperatureSummary from '../model/TemperatureSummary';

/**
* Environment service.
* @module api/EnvironmentApi
* @version 1.0.0
*/
export default class EnvironmentApi {

    /**
    * Constructs a new EnvironmentApi. 
    * @alias module:api/EnvironmentApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instanc
    e} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }

    /**
     * Callback function to receive the result of the getForecast operation.
     * @callback moduleapi/EnvironmentApi~getForecastCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ForecastResponse{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Number} days 
     * @param {module:api/EnvironmentApi~getForecastCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    getForecast(days, callback) {
      
      let postBody = null;
      // verify the required parameter 'days' is set
      if (days === undefined || days === null) {
        throw new Error("Missing the required parameter 'days' when calling getForecast");
      }

      let pathParams = {
        'days': days
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ForecastResponse;

      return this.apiClient.callApi(
        '/temperature/forecast/{days}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the getHeaterState operation.
     * @callback moduleapi/EnvironmentApi~getHeaterStateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/HeaterState{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * gets the state of the heater
     * @param {String} zoneId 
     * @param {module:api/EnvironmentApi~getHeaterStateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    getHeaterState(zoneId, callback) {
      
      let postBody = null;
      // verify the required parameter 'zoneId' is set
      if (zoneId === undefined || zoneId === null) {
        throw new Error("Missing the required parameter 'zoneId' when calling getHeaterState");
      }

      let pathParams = {
        'zoneId': zoneId
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = HeaterState;

      return this.apiClient.callApi(
        '/temperature/{zoneId}/heater', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the getZoneTemperature operation.
     * @callback moduleapi/EnvironmentApi~getZoneTemperatureCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemperatueZoneStatus{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} zoneId 
     * @param {module:api/EnvironmentApi~getZoneTemperatureCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    getZoneTemperature(zoneId, callback) {
      
      let postBody = null;
      // verify the required parameter 'zoneId' is set
      if (zoneId === undefined || zoneId === null) {
        throw new Error("Missing the required parameter 'zoneId' when calling getZoneTemperature");
      }

      let pathParams = {
        'zoneId': zoneId
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = TemperatueZoneStatus;

      return this.apiClient.callApi(
        '/temperature/{zoneId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the setHeaterState operation.
     * @callback moduleapi/EnvironmentApi~setHeaterStateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ApiResponse{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * turns the heater on or off
     * @param {String} zoneId 
     * @param {module:model/String} state 
     * @param {module:api/EnvironmentApi~setHeaterStateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    setHeaterState(zoneId, state, callback) {
      
      let postBody = null;
      // verify the required parameter 'zoneId' is set
      if (zoneId === undefined || zoneId === null) {
        throw new Error("Missing the required parameter 'zoneId' when calling setHeaterState");
      }
      // verify the required parameter 'state' is set
      if (state === undefined || state === null) {
        throw new Error("Missing the required parameter 'state' when calling setHeaterState");
      }

      let pathParams = {
        'zoneId': zoneId,'state': state
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ApiResponse;

      return this.apiClient.callApi(
        '/temperature/{zoneId}/heater/{state}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the temperatureSummary operation.
     * @callback moduleapi/EnvironmentApi~temperatureSummaryCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemperatureSummary{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {module:api/EnvironmentApi~temperatureSummaryCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    temperatureSummary(callback) {
      
      let postBody = null;

      let pathParams = {
        
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = TemperatureSummary;

      return this.apiClient.callApi(
        '/temperature', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

}