# home_iot_api

HomeIotApi - JavaScript client for home_iot_api
The API for the EatBacon IOT project
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.javascript.JavaScriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install home_iot_api --save
```

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var HomeIotApi = require('home_iot_api');

var api = new HomeIotApi.DeviceApi()
var opts = { 
  'skip': 56, // {Number} number of records to skip
  'limit': 56 // {Number} max number of records to return
};
var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.getDevices(opts, callback);
```

## Documentation for API Endpoints

All URIs are relative to *https://virtserver.swaggerhub.com/GWENDILLT/Film/1.0.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*HomeIotApi.DeviceApi* | [**getDevices**](docs/DeviceApi.md#getDevices) | **GET** /devices | 
*HomeIotApi.DeviceApi* | [**register**](docs/DeviceApi.md#register) | **POST** /devices | 
*HomeIotApi.EnvironmentApi* | [**getForecast**](docs/EnvironmentApi.md#getForecast) | **GET** /temperature/forecast/{days} | 
*HomeIotApi.EnvironmentApi* | [**getHeaterState**](docs/EnvironmentApi.md#getHeaterState) | **GET** /temperature/{zoneId}/heater | 
*HomeIotApi.EnvironmentApi* | [**getZoneTemperature**](docs/EnvironmentApi.md#getZoneTemperature) | **GET** /temperature/{zoneId} | 
*HomeIotApi.EnvironmentApi* | [**setHeaterState**](docs/EnvironmentApi.md#setHeaterState) | **POST** /temperature/{zoneId}/heater/{state} | 
*HomeIotApi.EnvironmentApi* | [**temperatureSummary**](docs/EnvironmentApi.md#temperatureSummary) | **GET** /temperature | 
*HomeIotApi.ZWaveApi* | [**getLightingSummary**](docs/ZWaveApi.md#getLightingSummary) | **GET** /lightingSummary | 
*HomeIotApi.ZWaveApi* | [**getSwitchState**](docs/ZWaveApi.md#getSwitchState) | **GET** /lighting/switches/{deviceId} | 
*HomeIotApi.ZWaveApi* | [**setDimmer**](docs/ZWaveApi.md#setDimmer) | **POST** /lighting/dimmers/{deviceId}/{value} | 
*HomeIotApi.ZWaveApi* | [**setDimmerTimer**](docs/ZWaveApi.md#setDimmerTimer) | **POST** /lighting/dimmers/{deviceId}/{value}/timer/{timeunit} | 
*HomeIotApi.ZWaveApi* | [**setSwitch**](docs/ZWaveApi.md#setSwitch) | **POST** /lighting/switches/{deviceId}/{value} | 
*HomeIotApi.ZWaveApi* | [**setSwitchTimer**](docs/ZWaveApi.md#setSwitchTimer) | **POST** /lighting/switches/{deviceId}/{value}/timer/{minutes} | 
*HomeIotApi.ZonesApi* | [**getZones**](docs/ZonesApi.md#getZones) | **GET** /zones | 
*HomeIotApi.ZonesApi* | [**quietZone**](docs/ZonesApi.md#quietZone) | **GET** /zones/{zoneId}/quiet | 

## Documentation for Models

 - [HomeIotApi.ApiResponse](docs/ApiResponse.md)
 - [HomeIotApi.City](docs/City.md)
 - [HomeIotApi.DeviceRegistrationInfo](docs/DeviceRegistrationInfo.md)
 - [HomeIotApi.DeviceState](docs/DeviceState.md)
 - [HomeIotApi.Forecast](docs/Forecast.md)
 - [HomeIotApi.ForecastResponse](docs/ForecastResponse.md)
 - [HomeIotApi.ForecastTemperature](docs/ForecastTemperature.md)
 - [HomeIotApi.HeaterState](docs/HeaterState.md)
 - [HomeIotApi.LightingSummary](docs/LightingSummary.md)
 - [HomeIotApi.LightingZone](docs/LightingZone.md)
 - [HomeIotApi.LightingZoneStatus](docs/LightingZoneStatus.md)
 - [HomeIotApi.TemperatueZoneStatus](docs/TemperatueZoneStatus.md)
 - [HomeIotApi.TemperatureSummary](docs/TemperatureSummary.md)
 - [HomeIotApi.TemperatureZone](docs/TemperatureZone.md)
 - [HomeIotApi.WeatherForecast](docs/WeatherForecast.md)

## Documentation for Authorization

 All endpoints do not require authorization.

