/*
 * home-iot-api
 * The API for the EatBacon IOT project
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.54
 *
 * Do not edit the class manually.
 *
 */
import ApiClient from "../ApiClient";
import ApiResponse from '../model/ApiResponse';
import DeviceState from '../model/DeviceState';
import LightingSummary from '../model/LightingSummary';

/**
* ZWave service.
* @module api/ZWaveApi
* @version 1.0.0
*/
export default class ZWaveApi {

    /**
    * Constructs a new ZWaveApi. 
    * @alias module:api/ZWaveApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instanc
    e} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }

    /**
     * Callback function to receive the result of the getLightingSummary operation.
     * @callback moduleapi/ZWaveApi~getLightingSummaryCallback
     * @param {String} error Error message, if any.
     * @param {module:model/LightingSummary{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {module:api/ZWaveApi~getLightingSummaryCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    getLightingSummary(callback) {
      
      let postBody = null;

      let pathParams = {
        
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = LightingSummary;

      return this.apiClient.callApi(
        '/lightingSummary', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the getSwitchState operation.
     * @callback moduleapi/ZWaveApi~getSwitchStateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/DeviceState{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} deviceId 
     * @param {module:api/ZWaveApi~getSwitchStateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    getSwitchState(deviceId, callback) {
      
      let postBody = null;
      // verify the required parameter 'deviceId' is set
      if (deviceId === undefined || deviceId === null) {
        throw new Error("Missing the required parameter 'deviceId' when calling getSwitchState");
      }

      let pathParams = {
        'deviceId': deviceId
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = DeviceState;

      return this.apiClient.callApi(
        '/lighting/switches/{deviceId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the setDimmer operation.
     * @callback moduleapi/ZWaveApi~setDimmerCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ApiResponse{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} deviceId 
     * @param {Number} value 
     * @param {module:api/ZWaveApi~setDimmerCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    setDimmer(deviceId, value, callback) {
      
      let postBody = null;
      // verify the required parameter 'deviceId' is set
      if (deviceId === undefined || deviceId === null) {
        throw new Error("Missing the required parameter 'deviceId' when calling setDimmer");
      }
      // verify the required parameter 'value' is set
      if (value === undefined || value === null) {
        throw new Error("Missing the required parameter 'value' when calling setDimmer");
      }

      let pathParams = {
        'deviceId': deviceId,'value': value
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ApiResponse;

      return this.apiClient.callApi(
        '/lighting/dimmers/{deviceId}/{value}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the setDimmerTimer operation.
     * @callback moduleapi/ZWaveApi~setDimmerTimerCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ApiResponse{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * sets a dimmer to a specific value on a timer
     * @param {String} deviceId 
     * @param {Number} value 
     * @param {Number} timeunit 
     * @param {Object} opts Optional parameters
     * @param {module:model/String} opts.units  (default to <.>)
     * @param {module:api/ZWaveApi~setDimmerTimerCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    setDimmerTimer(deviceId, value, timeunit, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'deviceId' is set
      if (deviceId === undefined || deviceId === null) {
        throw new Error("Missing the required parameter 'deviceId' when calling setDimmerTimer");
      }
      // verify the required parameter 'value' is set
      if (value === undefined || value === null) {
        throw new Error("Missing the required parameter 'value' when calling setDimmerTimer");
      }
      // verify the required parameter 'timeunit' is set
      if (timeunit === undefined || timeunit === null) {
        throw new Error("Missing the required parameter 'timeunit' when calling setDimmerTimer");
      }

      let pathParams = {
        'deviceId': deviceId,'value': value,'timeunit': timeunit
      };
      let queryParams = {
        'units': opts['units']
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ApiResponse;

      return this.apiClient.callApi(
        '/lighting/dimmers/{deviceId}/{value}/timer/{timeunit}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the setSwitch operation.
     * @callback moduleapi/ZWaveApi~setSwitchCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ApiResponse{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} deviceId 
     * @param {module:model/String} value 
     * @param {module:api/ZWaveApi~setSwitchCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    setSwitch(deviceId, value, callback) {
      
      let postBody = null;
      // verify the required parameter 'deviceId' is set
      if (deviceId === undefined || deviceId === null) {
        throw new Error("Missing the required parameter 'deviceId' when calling setSwitch");
      }
      // verify the required parameter 'value' is set
      if (value === undefined || value === null) {
        throw new Error("Missing the required parameter 'value' when calling setSwitch");
      }

      let pathParams = {
        'deviceId': deviceId,'value': value
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ApiResponse;

      return this.apiClient.callApi(
        '/lighting/switches/{deviceId}/{value}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
    /**
     * Callback function to receive the result of the setSwitchTimer operation.
     * @callback moduleapi/ZWaveApi~setSwitchTimerCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ApiResponse{ data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * sets a switch to a specific value on a timer
     * @param {String} deviceId 
     * @param {module:model/String} value 
     * @param {Number} minutes 
     * @param {module:api/ZWaveApi~setSwitchTimerCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link <&vendorExtensions.x-jsdoc-type>}
     */
    setSwitchTimer(deviceId, value, minutes, callback) {
      
      let postBody = null;
      // verify the required parameter 'deviceId' is set
      if (deviceId === undefined || deviceId === null) {
        throw new Error("Missing the required parameter 'deviceId' when calling setSwitchTimer");
      }
      // verify the required parameter 'value' is set
      if (value === undefined || value === null) {
        throw new Error("Missing the required parameter 'value' when calling setSwitchTimer");
      }
      // verify the required parameter 'minutes' is set
      if (minutes === undefined || minutes === null) {
        throw new Error("Missing the required parameter 'minutes' when calling setSwitchTimer");
      }

      let pathParams = {
        'deviceId': deviceId,'value': value,'minutes': minutes
      };
      let queryParams = {
        
      };
      let headerParams = {
        
      };
      let formParams = {
        
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ApiResponse;

      return this.apiClient.callApi(
        '/lighting/switches/{deviceId}/{value}/timer/{minutes}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

}