/*
 * Decompiled with CFR 0.152.
 */
package com.controllers;

import com.dtos.LieuDto;
import com.services.impl.LieuServiceImpl;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lieux"})
public class LieuController {
    private final LieuServiceImpl lieuService;

    public LieuController(LieuServiceImpl lieuService) {
        this.lieuService = lieuService;
    }

    @GetMapping
    public List<LieuDto> getLieu() {
        return this.lieuService.getAllLieu();
    }

    @PostMapping
    public LieuDto saveLieu(@RequestBody LieuDto lieuDto) {
        return this.lieuService.saveLieu(lieuDto);
    }

    @GetMapping(value={"/{lieuxId}"})
    public LieuDto lieuDto(@PathVariable Long lieuxId) {
        return this.lieuService.getLieuById(lieuxId);
    }

    @PutMapping(value={"/{lieuxId}"})
    public LieuDto updateLieuDto(@PathVariable Long lieuxId, @RequestBody LieuDto lieuDto) {
        return this.lieuService.updateLieu(lieuxId, lieuDto);
    }

    @DeleteMapping(value={"/{lieuxId}"})
    public Boolean deleteLieux(@PathVariable Long lieuxId) {
        return this.lieuService.deleteLieu(lieuxId);
    }
}

