/*
 * Decompiled with CFR 0.152.
 */
package com.services.impl;

import com.dtos.MembreDto;
import com.entities.Membre;
import com.repositories.MembreRepository;
import com.services.MembreService;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="membreService")
public class MembreServiceImpl
implements MembreService {
    private final MembreRepository membreRepository;

    public MembreServiceImpl(MembreRepository membreRepository) {
        this.membreRepository = membreRepository;
    }

    @Override
    public MembreDto saveMembre(MembreDto membreDto) {
        if (this.membreDtoAlreadyExistByName(membreDto)) {
            throw new EntityExistsException("Membre \u00e9xite d\u00e9j\u00e0");
        }
        Membre membre = this.membreDtoToEntity(membreDto);
        membre = (Membre)this.membreRepository.save(membre);
        return this.membreEntityToDto(membre);
    }

    @Override
    public MembreDto getMembreById(Long membreId) {
        Membre membre = (Membre)this.membreRepository.findById(membreId).orElseThrow(() -> new EntityNotFoundException("Membre n'\u00e9xiste pas"));
        return this.membreEntityToDto(membre);
    }

    @Override
    public boolean deleteMembre(Long memberId) {
        this.membreRepository.deleteById(memberId);
        return true;
    }

    @Override
    public MembreDto updateMembre(Long membreId, MembreDto membreDto) {
        if (!this.membreRepository.existsById(membreId)) {
            throw new EntityNotFoundException("Membre n'\u00e9xiste pas");
        }
        if (this.membreDtoAlreadyExistByName(membreDto)) {
            throw new EntityExistsException("Membre \u00e9xite d\u00e9j\u00e0");
        }
        Membre membre = this.membreDtoToEntity(membreDto);
        membre.setId(membreId);
        this.membreRepository.save(membre);
        return this.membreEntityToDto(membre);
    }

    @Override
    public List<MembreDto> getAllMembres() {
        ArrayList<MembreDto> membresDtos = new ArrayList<MembreDto>();
        List membres = this.membreRepository.findAll();
        membres.forEach(lieu -> membresDtos.add(this.membreEntityToDto((Membre)lieu)));
        return membresDtos;
    }

    private MembreDto membreEntityToDto(Membre membre) {
        MembreDto membreDto = new MembreDto();
        membreDto.setId(membre.getId());
        membreDto.setAdresse(membre.getAdresse());
        membreDto.setNom(membre.getNom());
        membreDto.setPrenom(membre.getPrenom());
        membreDto.setMail(membre.getMail());
        membreDto.setDateNaissance(membre.getDateNaissance());
        membreDto.setMotDePasse(membre.getMotDePasse());
        return membreDto;
    }

    private Membre membreDtoToEntity(MembreDto membreDto) {
        Membre membre = new Membre();
        membre.setId(membreDto.getId());
        membre.setAdresse(membreDto.getAdresse());
        membre.setNom(membreDto.getNom());
        membre.setPrenom(membreDto.getPrenom());
        membre.setMail(membreDto.getMail());
        membre.setDateNaissance(membreDto.getDateNaissance());
        membre.setMotDePasse(membreDto.getMotDePasse());
        return membre;
    }

    private boolean membreDtoAlreadyExistByName(MembreDto membreDto) {
        List<MembreDto> membres = this.getAllMembres();
        for (MembreDto membre : membres) {
            if (!membre.getNom().equals(membreDto.getNom()) || !membre.getPrenom().equals(membreDto.getPrenom())) continue;
            return true;
        }
        return false;
    }
}

