/*
 * Decompiled with CFR 0.152.
 */
package com.controllers;

import com.dtos.MembreDto;
import com.services.impl.MembreServiceImpl;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/membres"})
public class MembreController {
    private final MembreServiceImpl memberService;

    public MembreController(MembreServiceImpl memberService) {
        this.memberService = memberService;
    }

    @GetMapping
    public List<MembreDto> getMembres() {
        return this.memberService.getAllMembres();
    }

    @PostMapping
    public MembreDto saveMembre(@RequestBody MembreDto membreDto) {
        return this.memberService.saveMembre(membreDto);
    }

    @GetMapping(value={"/{membresId}"})
    public MembreDto membreDto(@PathVariable Long membresId) {
        return this.memberService.getMembreById(membresId);
    }

    @PutMapping(value={"/{membresId}"})
    public MembreDto updateMembreDto(@RequestBody MembreDto membreDto, @PathVariable Long membresId) {
        return this.memberService.updateMembre(membresId, membreDto);
    }

    @DeleteMapping(value={"/{membresId}"})
    public Boolean deleteMembre(@PathVariable Long membresId) {
        return this.memberService.deleteMembre(membresId);
    }
}

