#include<stdio.h>

#define MAX_NB 1024
#define PERIOD 5
#define PLUS_INF 999999
int Bitrates[MAX_NB];

int readBitrates(char *fname)
{
	int n = 0;
	FILE *fp = fopen(fname, "r");

	while (fscanf(fp, "%d", &(Bitrates[n])) == 1) n++;
	fclose(fp);
	return n;
}

int costInterval(int i, int j)
{
	int k, max = 0, cost = 0;
	// calculer la val max entre Bitrates[i] et Br[j-1]
	for (k=i; k<j; k++) 
		max = max < Bitrates[k] ? Bitrates[k] : max;
	// calculer la somme (max - Br[i])
	for (k=i; k<j; k++) 
		cost += max - Bitrates[k];
	return cost;
}

int  bellman(int n, int p)
{
	int i, j;
	int D[MAX_NB+1];
	// init D et C  (i0 == 0)
	for(i=0; i<=n; i++) D[i] = PLUS_INF; 
	D[0] = 0;

	// boucle principale
	for(j=1; j<=n; j++) {
		int first = (j - 2*p) >= 0 ? j-2*p : 0;
		int last = j<n ? j-p : j-1;
		for (i=first; i<=last; i++) {
			int v = D[i] + costInterval(i, j);
			if (v < D[j]) 
				D[j] = v;
		}
	}
	return D[n];
}

main(int argc, char **argv)
{
	int totalCost, nb; // number of bitrates

	nb = readBitrates(argv[1]);
	printf("nb %d - last bitrate %d\n", nb,  Bitrates[nb-1]);
	printf("cost [0..3[ : %d\n", costInterval(0, 3));
	totalCost = bellman(nb, PERIOD);
	printf("cost for p=%d : %d\n", PERIOD, totalCost);
}


